/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.entity.projectile;

import dev.toma.gunsrpg.GunsRPG;
import dev.toma.gunsrpg.api.common.data.IPlayerData;
import dev.toma.gunsrpg.common.capability.PlayerData;
import dev.toma.gunsrpg.common.init.ModDamageSources;
import dev.toma.gunsrpg.common.init.ModSounds;
import dev.toma.gunsrpg.common.item.guns.GunItem;
import dev.toma.gunsrpg.util.properties.Properties;
import dev.toma.gunsrpg.util.properties.PropertyContext;
import dev.toma.gunsrpg.util.properties.PropertyKey;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IAngerable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SPlaySoundEffectPacket;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;

public abstract class AbstractProjectile
extends ProjectileEntity
implements IEntityAdditionalSpawnData {
    protected final PropertyContext propertyContext = PropertyContext.create();
    private final Set<UUID> passedPlayers = new HashSet<UUID>();
    private final ItemStack weapon;
    private float projectileDamage;
    private float velocity;
    private int delay;
    private boolean supersonic;

    public AbstractProjectile(EntityType<? extends AbstractProjectile> type, World level) {
        super(type, level);
        this.weapon = ItemStack.field_190927_a;
    }

    public AbstractProjectile(EntityType<? extends AbstractProjectile> type, World world, LivingEntity owner) {
        super(type, world);
        this.func_212361_a((Entity)owner);
        this.passedPlayers.add(owner.func_110124_au());
        this.weapon = owner.func_184614_ca();
        this.field_70145_X = true;
        Vector3d position = owner.func_213303_ch();
        this.func_70107_b(position.field_72450_a, position.field_72448_b + (double)owner.func_70047_e(), position.field_72449_c);
    }

    public abstract boolean func_70112_a(double var1);

    public abstract void preTick();

    public abstract void postTick();

    protected abstract void func_230299_a_(BlockRayTraceResult var1);

    protected abstract void func_213868_a(EntityRayTraceResult var1);

    public boolean allowBaseTick() {
        return true;
    }

    public void setup(float damage, float velocity, int delay) {
        this.projectileDamage = damage;
        this.velocity = velocity;
        this.delay = delay;
        this.supersonic = velocity > 10.0f;
        this.onDamageChanged();
    }

    public void fire(float xRot, float yRot, float inaccuracy) {
        float inX = 0.0f;
        float inY = 0.0f;
        if ((double)inaccuracy != 0.0) {
            float base = 3.5f;
            float x = (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * inaccuracy;
            float y = (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * inaccuracy;
            inX = base * x;
            inY = base * y;
        }
        Vector3d vector3d = Vector3d.func_189986_a((float)(xRot + inX), (float)(yRot + inY));
        this.func_213317_d(vector3d.func_216372_d((double)this.velocity, (double)this.velocity, (double)this.velocity));
        this.field_70177_z = yRot + inY;
        this.updateDirection();
        this.ifShotByPlayer(this::aggroNearby);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void checkForCollisions(Vector3d v1, Vector3d v2) {
        EntityRayTraceResult entityHit;
        BlockRayTraceResult result = this.field_70170_p.func_217299_a(new RayTraceContext(v1, v2, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this));
        if (result.func_216346_c() != RayTraceResult.Type.MISS) {
            v2 = result.func_216347_e();
        }
        if ((entityHit = this.traceEntity(v1, v2)) != null) {
            result = entityHit;
        }
        if (result != null) {
            RayTraceResult.Type type = result.func_216346_c();
            if (type == RayTraceResult.Type.ENTITY) {
                this.func_213868_a((EntityRayTraceResult)result);
            } else if (type == RayTraceResult.Type.BLOCK) {
                this.func_230299_a_(result);
            }
        }
    }

    public EntityRayTraceResult traceEntity(Vector3d v1, Vector3d v2) {
        return ProjectileHelper.func_221269_a((World)this.field_70170_p, (Entity)this, (Vector3d)v1, (Vector3d)v2, (AxisAlignedBB)this.func_174813_aQ().func_216361_a(this.func_213322_ci()).func_186662_g(1.0), arg_0 -> ((AbstractProjectile)this).func_230298_a_(arg_0));
    }

    public float getProjectileDamage() {
        return this.projectileDamage;
    }

    public void func_70071_h_() {
        this.preTick();
        if (this.allowBaseTick()) {
            super.func_70071_h_();
        }
        this.updateDirection();
        Vector3d v1 = this.func_213303_ch();
        Vector3d v2 = v1.func_178787_e(this.func_213322_ci());
        this.checkForCollisions(v1, v2);
        if (this.supersonic) {
            this.passAround();
        }
        this.postTick();
        Vector3d delta = this.func_213322_ci();
        double x = this.func_226277_ct_() + delta.field_72450_a;
        double y = this.func_226278_cu_() + delta.field_72448_b;
        double z = this.func_226281_cx_() + delta.field_72449_c;
        this.func_70107_b(x, y, z);
    }

    public ItemStack getWeaponSource() {
        return this.weapon;
    }

    public void writeSpawnData(PacketBuffer buffer) {
        Vector3d position = this.func_213303_ch();
        Vector3d delta = this.func_213322_ci();
        buffer.writeDouble(position.field_72450_a);
        buffer.writeDouble(position.field_72448_b);
        buffer.writeDouble(position.field_72449_c);
        buffer.writeDouble(delta.field_72450_a);
        buffer.writeDouble(delta.field_72448_b);
        buffer.writeDouble(delta.field_72449_c);
        buffer.writeFloat(this.field_70177_z);
        this.propertyContext.encode(buffer);
    }

    public void readSpawnData(PacketBuffer buffer) {
        double px = buffer.readDouble();
        double py = buffer.readDouble();
        double pz = buffer.readDouble();
        double dx = buffer.readDouble();
        double dy = buffer.readDouble();
        double dz = buffer.readDouble();
        this.field_70177_z = buffer.readFloat();
        this.propertyContext.decode(buffer);
        this.func_70107_b(px, py, pz);
        this.func_213293_j(dx, dy, dz);
    }

    public <V> V getProperty(PropertyKey<V> key) {
        return this.propertyContext.getProperty(key);
    }

    public <V> void setProperty(PropertyKey<V> key, V value) {
        this.propertyContext.setProperty(key, value);
    }

    public void addProperties(PropertyContext context) {
        context.moveContents(this.propertyContext);
    }

    protected void func_70088_a() {
    }

    protected boolean canApplyGravity() {
        return this.field_70173_aa >= this.delay;
    }

    protected void applyGravity(float amount) {
        this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, (double)(-amount), 0.0));
    }

    protected void applyGravity() {
        if (this.canApplyGravity()) {
            this.applyGravity(0.05f);
        }
    }

    protected void reduceDamage(float amount) {
        this.projectileDamage -= amount;
        this.onDamageChanged();
    }

    protected void mulDamage(float f) {
        this.projectileDamage *= f;
        this.onDamageChanged();
    }

    protected void updateDirection() {
        Vector3d delta = this.func_213322_ci();
        double dx = delta.field_72450_a;
        double dy = delta.field_72448_b;
        double dz = delta.field_72449_c;
        float motionSqrt = MathHelper.func_76133_a((double)(dx * dx + dz * dz));
        this.field_70127_C = this.field_70125_A = -((float)(MathHelper.func_181159_b((double)dy, (double)motionSqrt) * 57.29577951308232));
    }

    protected DamageSource getDamageSource(Entity owner) {
        return ModDamageSources.gunAttack(owner, this, this.weapon);
    }

    void ifShotByPlayer(Consumer<PlayerEntity> event) {
        Entity entity = this.func_234616_v_();
        if (entity instanceof PlayerEntity) {
            event.accept((PlayerEntity)entity);
        }
    }

    boolean canHeadshotEntity(Entity victim) {
        EntitySize size = victim.func_213305_a(victim.func_213283_Z());
        double ratio = size.field_220316_b / size.field_220315_a;
        return ratio > 1.0;
    }

    protected void hurtTarget(Entity entity, Entity owner) {
        this.propertyContext.handleConditionally(Properties.IS_HEADSHOT, value -> value, headshot -> this.mulDamage(this.getHeadshotMultiplier()));
        if (this.weapon.func_77973_b() instanceof GunItem) {
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                GunItem gun = (GunItem)this.weapon.func_77973_b();
                if (owner instanceof PlayerEntity) {
                    this.projectileDamage = gun.modifyProjectileDamage(this, livingEntity, (PlayerEntity)owner, this.projectileDamage);
                }
                livingEntity.func_70097_a(this.getDamageSource(owner), this.projectileDamage);
                if (livingEntity.func_233643_dh_()) {
                    gun.onKillEntity(this, livingEntity, this.weapon, (LivingEntity)owner);
                } else {
                    gun.onHitEntity(this, livingEntity, this.weapon, (LivingEntity)owner);
                }
            } else if (entity instanceof PartEntity) {
                DamageSource source = ModDamageSources.gunAttack(owner, this, this.weapon);
                entity.func_70097_a(source, this.projectileDamage);
            }
        } else {
            entity.func_70097_a(ModDamageSources.gunAttack(owner, this, this.weapon), this.projectileDamage);
        }
    }

    private void passAround() {
        if (!this.field_70170_p.field_72995_K) {
            ServerWorld serverLevel = (ServerWorld)this.field_70170_p;
            Vector3d pos = this.func_213303_ch();
            List players = serverLevel.func_175647_a(ServerPlayerEntity.class, this.func_174813_aQ().func_186662_g(3.0), pl -> !this.passedPlayers.contains(pl.func_110124_au()));
            for (ServerPlayerEntity player : players) {
                this.passedPlayers.add(player.func_110124_au());
                player.field_71135_a.func_147359_a((IPacket)new SPlaySoundEffectPacket(ModSounds.BULLET_WHIZZ, SoundCategory.MASTER, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, 0.2f, 1.0f));
            }
        }
    }

    protected void aggroNearby(PlayerEntity player) {
        if (player.func_184812_l_() || player.func_175149_v()) {
            return;
        }
        PlayerData.get(player).ifPresent(data -> {
            double mobScareRange = GunsRPG.config.world.mobConfig.shootingMobAggroRange;
            GunItem gun = (GunItem)this.weapon.func_77973_b();
            double noiseMultiplier = gun.getNoiseMultiplier(data.getAttributes());
            double actualScareRange = mobScareRange * noiseMultiplier;
            Entity owner = this.func_234616_v_();
            List list = this.field_70170_p.func_175647_a(MonsterEntity.class, this.func_174813_aQ().func_186662_g(actualScareRange), ent -> ent != owner);
            for (MonsterEntity entity : list) {
                if (entity.func_70638_az() == null) {
                    entity.func_70661_as().func_75492_a(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 1.0);
                }
                if (!(entity.func_70068_e((Entity)player) < 256.0) || !(entity instanceof IAngerable)) continue;
                entity.func_70624_b((LivingEntity)player);
            }
        });
    }

    private float getHeadshotMultiplier() {
        LazyOptional<IPlayerData> optional;
        Entity src = this.func_234616_v_();
        if (src instanceof PlayerEntity && this.weapon.func_77973_b() instanceof GunItem && (optional = PlayerData.get((PlayerEntity)src)).isPresent()) {
            IPlayerData data = (IPlayerData)optional.orElse(null);
            GunItem item = (GunItem)this.weapon.func_77973_b();
            return (float)item.getHeadshotMultiplier(data.getAttributes());
        }
        return 1.0f;
    }

    protected void onDamageChanged() {
        if (this.projectileDamage <= 0.0f && !this.field_70170_p.field_72995_K) {
            this.func_70106_y();
        }
    }
}

